/*********************************

	testADC.cpp
	
	Author:
		Weston Griffin	    
	Description:
	
	History:
	
	
***********************************/  
//------------------ include files --------------------
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <sys/proxy.h>
#include <sys/irqinfo.h>
#include <sys/kernel.h>
#include <sys/sched.h>
#include <DML_child.h>
#include "DML_servo2go.h"
#include <DML_timer.h>
#include <DML_shmem.h>
#include "testADC.h"

static   servo2go s2go(0x300);
static	 off_t wbase = 0x300;

volatile unsigned dummy;
static pid_t irq5_pid;
static pid_t isrProxy;



static ADC_STRUCT * adc = new("shm_adc") ShMem<ADC_STRUCT>; 


#pragma off(check_stack);
pid_t far irqHandler ()
{
	return (isrProxy);
}
#pragma on(check_stack);

void main( void )
{
	setprio(0, 27);
	DML_child isr("isr_process");
	isrProxy = isr.proxy ;
	s2go.init();
	s2go.setADCautoZero(0);
	
	isr.sendInfoMsg();
	

	printf("--------------  ADC_EOC test ------------------\n");

	if ( (irq5_pid = qnx_hint_attach (5 , &irqHandler, FP_SEG(&dummy) ) ) == -1 )
	{
		printf("unable to attach hardware interrupt\n");
	}
	s2go.enableInterrupt(S2G_EOC_INT);
	adc->count = 0;
	s2go.startSingleADConversion(ADCport[adc->count]);	
	
	float toggleMe = 5.0;
	DML_timer timer(FREQ1000Hz);
	s2go.DAC(DAC_4, 5.0);

	while(!kbhit())
	{
		Receive(timer, 0, 0);

		toggleMe < 0 ? toggleMe = 5.0 : toggleMe = -0.01;
//		s2go.DAC(DAC_4, toggleMe);	

		adc->count = 0;
		s2go.startSingleADConversion(ADCport[adc->count]);
			
		
/*		printf("p0 = %8.5f, p1 = %8.5f, p2 = %8.5f, p3 = %8.5f \r",
		adc->voltage[0], 
		adc->voltage[1],
		adc->voltage[2],
		adc->voltage[3]); 
*/
	}
	qnx_hint_detach (irq5_pid);
	isr.kill();
	s2go.DAC(DAC_4, 0.0);
	s2go.disableInterrupt(S2G_EOC_INT);
	s2go.~servo2go();
	timer.stop();
} 
