/*********************************

	isr_process.cpp
	
	Author:
	    Ryan Findley
		Modified by Weston Griffin	    
	Description:
		  
	An object-oriented approach to the servo2go card.
	The software which we got with the card failed to compile,
	and was hard to understand. This attempts to make it easier.
	
	History:
	
	8/4/99	ryan	started
	02/25/00 wbg	removed far handler and added some functions
	
***********************************/  
//#define TEST  
//#define TEST_ADC_POLL
//#define TEST_ADC_EOC
//------------------ include files --------------------
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <sys/proxy.h>
#include <sys/irqinfo.h>
#include <sys/kernel.h>
#include <sys/sched.h>
#include "DML_servo2go.h"
#include <DML_child.h>
#include <DML_shmem.h>
#include "testADC.h"

void main () 
{
	setprio(0,28);
	DML_master master;
	servo2go s2go(0x300);
	master.sendInfoMsg();
	printf("child process created\n");
	static ADC_STRUCT * adc = new("shm_adc") ShMem<ADC_STRUCT>; 	
	float testVoltage;
	
	
	while (1) {
//		printf("waiting\n");
		Receive(master.proxy,0,0);

		testVoltage = 4 - (adc->count); // voltage should step down as coutn increases
		s2go.DAC(DAC_4, testVoltage);

		if (adc->count < 4) {
			//printf("adc count = %d\n", adc->count);
			adc->voltage[adc->count] = s2go.readADC(ADCport[adc->count]);
			adc->count++;
		}
		if (adc->count < 4) {
			s2go.startSingleADConversion(ADCport[adc->count]);
		}
			
		//if (adc->count == 4)
//		s2go.DAC(DAC_4, 0.5);

	}
	
}