/*************************************************

DML_master.cpp

introduces the master class. Provides functions for handling
communication with a master process.

Author: Ryan Findley


History:
who	when		what
--------------------------------
ryan	5/10/99		started

***************************************************/
#define NOT_TEST

//----------------- include files -----------------------

#include "DML_child.hpp"
#include <sys/sched.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/kernel.h>

//----------------- definitions -------------------------


//----------------- module code -------------------------

int DML_master::id = -1;

DML_master::DML_master()
{
    id = getppid();
    proxy = -1;
    verbosity = LOUD;
    priority = getprio(0);
	signal(SIGUSR1,SIG_IGN);
}

DML_master::sendInfoMsg()
{
    childInfoStruct msg;
    int status;

    status = Receive(id, &msg, sizeof(childInfoStruct));
    if (status == -1 && verbosity == LOUD)
    	printf("error receiving message from master.\n");
    
    msg.priority = getprio(0);
    proxy = msg.proxy;
    verbosity = msg.verbosity;

    status = Reply(id, &msg, sizeof(childInfoStruct));
    if (status == -1 && verbosity == LOUD)
		printf("error replying message from master. \n");
}

int DML_master::getMsg(int rMsg)
{
    int status;
    int msg;
    
    status = Receive(id,&msg,sizeof(int));
    if (status == -1 && verbosity == LOUD)
    {
    	printf("Error receiving message from master.\n");
        return(-1);
    }
    status = Reply(id,&rMsg,sizeof(int));
    if(status == -1 && verbosity == LOUD)
    {
    	printf("Error replying to message from master.\n");
    	return(-1);
    }
    return(msg);
}


#ifdef TEST
//test harness

#include <signal.h>

void main(void)
{
	setprio(0,14);
	
	DML_master master;

	printf("waiting for info message.\n");
	master.sendInfoMsg();
	printf("got first info message.\n");

	int i;
	while(Receive(master.id,0,0) == -1)
		if(i++ > 1000) break;	//just chill
	
}

#endif //TEST       
