/*************************************

	DML_process.cpp
	
	Provides support for the DML_process class.
	Since most of this class is defined publicly inline,
	there are only a few functions in this file.
	
	History:
	7/29/99		ryan		added checkMsgBackup.
	7/29/99		ryan		added constructors/destructor
	
**************************************/
//#define TEST

#include "DML_process.h"
#include <sys/name.h>
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>

DML_process::DML_process()
{
	pid = -1;
	nodeID = 0;
	priority = -1;
}

DML_process::DML_process(const char *name, const nid_t theNid)
{
	pid = -1;
	nodeID = theNid;
	priority = -1;
	pid = qnx_name_locate(nodeID,name,0,NULL);
	if(pid == -1)
		printf("Error opening child %s from name server: name is not registered.\n",name);
}


int DML_process::fork()
{
	pid = ::fork();
	
	if( pid == -1 )
		return( FORK_FAIL );
	else if( pid == 0 )
		return( FORK_CHILD );
	else
		return( FORK_MASTER );
}


DML_process::checkMsgBackup()
{
	return( pid > 0 ? pid : PROC_DNE );
}


#ifdef TEST


void main( void )
{

	DML_process forkChild;
	
	forkChild.fork();
	
	if( forkChild.pid == -1 )
	{
		printf("fork fail!\n");
		exit(0);
	}
	else if( forkChild.pid == 0 )
		printf("child successfully forked.\n");
	else
		printf("master exists after fork.\n");
	
	exit(0);
}

#endif
