/*************************************************

DML_master.cpp

introduces the master class. Provides functions for handling
communication with a master process.

Author: Ryan Findley


History:
who     when            what
--------------------------------
ryan    5/10/99         started
ryan	7/28/99		fixed compatibility with DML_process

***************************************************/
//#define TEST

//----------------- include files -----------------------

#include "DML_child.h"
#include <sys/sched.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/kernel.h>

//----------------- definitions -------------------------


//----------------- module code -------------------------


DML_master::DML_master()
{
    pid = getppid();
    proxy = -1;
    verbosity = LOUD;
    priority = getprio(0);
    signal(SIGUSR1,SIG_IGN);
}

DML_master::sendInfoMsg()
{
    childInfoStruct msg;
    int status;

    status = Receive(pid, &msg, sizeof(childInfoStruct));
    if (status == -1 && verbosity == LOUD)
        printf("error receiving message from master.\n");
    
    msg.priority = getprio(0);
    proxy = msg.proxy;
    verbosity = msg.verbosity;

    status = Reply(pid, &msg, sizeof(childInfoStruct));
    if (status == -1 && verbosity == LOUD)
                printf("error replying message from master. \n");
}


#ifdef TEST
//test harness

#include <signal.h>

void main(void)
{
	setprio(0,14);
	
	DML_master master;

	printf("waiting for info message.\n");
	master.sendInfoMsg();
	printf("got first info message.\n");

	int i;
	while(Receive(master,0,0) == -1)
		if(i++ > 1000) break;
	
}

#endif //TEST       
